#!/usr/local/bin/python
# -*- coding: koi8-r -*-
"""Usage: %(program)s [options] SQL-QUERY
Options:
    -h          this help
    -d DB-FILE  ipcad db, default: /var/log/ipcad/ipcad.db
    -m          human output (html)
Version: %(__version__)s"""

import pysqlite2.dbapi2 as sqlite
import socket
import sys
import getopt

__version__ = 'Query IPCAD db, v. 0.01'

HEADER="""
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru" lang="ru">
<head>
<title>  ipcad.db</title>
<meta http-equiv="content-type" content="text/html; charset=KOI8-R">
</head>
<h1>DB: %(db)s<br>SQL: %(sqlexpr)s<br></h1>
<span style="font-family: courier; font-size: 7pt;">
"""

FOOTER='</span></html>'

KNOWN_HOSTS_PATH = '/usr/local/etc/trafst/known_hosts'
KNOWN_HOSTS = {}

def out( msg ):
  sys.stdout.write( msg + '\n' )

def panic( msg ):
  sys.stderr.write( msg + '\n' )
  sys.exit( 1 )

def usage():
  out( __doc__%globals() )
  sys.exit( 0 )


def gpbn( my_gpbn ):
	return socket.__dict__.get( 'getprotobynumber', my_gpbn )
@gpbn
def proto( protonumber ):
	protocols = \
	{0: 'IP',
	 1: 'ICMP',
	 2: 'IGMP',
	 3: 'GGP',
	 4: 'IPENCAP',
	 5: 'ST2',
	 6: 'TCP',
	 7: 'CBT',
	 8: 'EGP',
	 9: 'IGP',
	 10: 'BBN-RCC',
	 11: 'NVP',
	 12: 'PUP',
	 13: 'ARGUS',
	 14: 'EMCON',
	 15: 'XNET',
	 16: 'CHAOS',
	 17: 'UDP',
	 18: 'MUX',
	 19: 'DCN',
	 20: 'HMP',
	 21: 'PRM',
	 22: 'XNS-IDP',
	 23: 'TRUNK-1',
	 24: 'TRUNK-2',
	 25: 'LEAF-1',
	 26: 'LEAF-2',
	 27: 'RDP',
	 28: 'IRTP',
	 29: 'ISO-TP4',
	 30: 'NETBLT',
	 31: 'MFE-NSP',
	 32: 'MERIT-INP',
	 33: 'SEP',
	 34: '3PC',
	 35: 'IDPR',
	 36: 'XTP',
	 37: 'DDP',
	 38: 'IDPR-CMTP',
	 39: 'TP++',
	 40: 'IL',
	 41: 'IPV6',
	 42: 'SDRP',
	 43: 'IPV6-ROUTE',
	 44: 'IPV6-FRAG',
	 45: 'IDRP',
	 46: 'RSVP',
	 47: 'GRE',
	 48: 'MHRP',
	 49: 'BNA',
	 50: 'ESP',
	 51: 'AH',
	 52: 'I-NLSP',
	 53: 'SWIPE',
	 54: 'NARP',
	 55: 'MOBILE',
	 56: 'TLSP',
	 57: 'SKIP',
	 58: 'IPV6-ICMP',
	 59: 'IPV6-NONXT',
	 60: 'IPV6-OPTS',
	 61: 'ANY-HOST-INT',
	 62: 'CFTP',
	 63: 'ANY-LAN',
	 64: 'SAT-EXPAK',
	 65: 'KRYPTOLAN',
	 66: 'RVD',
	 67: 'IPPC',
	 68: 'ANY-DISTR-FS',
	 69: 'SAT-MON',
	 70: 'VISA',
	 71: 'IPCV',
	 72: 'CPNX',
	 73: 'CPHB',
	 74: 'WSN',
	 75: 'PVP',
	 76: 'BR-SAT-MON',
	 77: 'SUN-ND',
	 78: 'WB-MON',
	 79: 'WB-EXPAK',
	 80: 'ISO-IP',
	 81: 'VMTP',
	 82: 'SECURE-VMTP',
	 83: 'VINES',
	 84: 'TTP',
	 85: 'NSFNET-IGP',
	 86: 'DGP',
	 87: 'TCF',
	 88: 'EIGRP',
	 89: 'OSPF',
	 90: 'SPRITE-RPC',
	 91: 'LARP',
	 92: 'MTP',
	 93: 'AX.25',
	 94: 'IPIP',
	 95: 'MICP',
	 96: 'SCC-SP',
	 97: 'ETHERIP',
	 98: 'ENCAP',
	 99: 'ANY-PRIV-ENCRYPT-SCH',
	 100: 'GMTP',
	 101: 'IFMP',
	 102: 'PNNI',
	 103: 'PIM',
	 104: 'ARIS',
	 105: 'SCPS',
	 106: 'QNX',
	 107: 'A/N',
	 108: 'IPCOMP',
	 109: 'SNP',
	 110: 'COMPAQ-PEER',
	 111: 'IPX-IN-IP',
	 112: 'VRRP',
	 113: 'PGM',
	 114: 'ANY-0-HOP',
	 115: 'L2TP',
	 116: 'DDX',
	 117: 'IATP',
	 118: 'ST',
	 119: 'SRP',
	 120: 'UTI',
	 121: 'SMP',
	 122: 'SM',
	 123: 'PTP',
	 124: 'ISIS',
	 125: 'FIRE',
	 126: 'CRTP',
	 127: 'CRUDP',
	 128: 'SSCOPMCE',
	 129: 'IPLT',
	 130: 'SPS',
	 131: 'PIPE',
	 132: 'SCTP',
	 133: 'FC',
	 254: 'DIVERT',
	 255: 'RESERVED'}
	return protocols.get( protonumber, '%d(?)'%protonumber )

def html_proto( protonum ):
	return '<span title="protocol ID: %s">%s</span>'%(str(protonum),proto(protonum))

def serv( port ):
	try:
		return socket.getservbyport( int(port) )
	except:
		return str(port)+'(?)'

def html_serv( port ):
	return '<span title="port: %s">%s</span>'%(str(port),serv(port))

B  = '1'
KB = '1024'
MB = '1048576'
GB = '1073741824'
HB = '<HB>'
def hbytes( arg0, arg1=HB ):
	if arg1 == B:
		return arg0
	elif arg1 == KB:
		return '%.2fK'%(arg0/1024.)
	elif arg1 == MB:
		return '%.2fM'%(arg0/1048576.)
	elif arg1 == GB:
		return '%.2fG'%(arg0/1073741824.)
	elif arg1 == HB:
		if arg0/1073741824. >= 1:
			return hbytes( arg0, GB )
		elif arg0/1048576. >= 1:
			return hbytes( arg0, MB )
		elif arg0/1024. >= 1:
			return hbytes( arg0, KB )
		else:
			return hbytes( arg0, B )

def html_hbytes( arg0, arg1=HB ):
	c = ''
	if int( arg0 ) > int( GB):
		c = 'style="color: red;"'
	elif int( arg0 ) > 500*int( MB ):
		c = 'style="color: orange;"'
	return '<span title="%s bytes" %s>%s</span>'%(str(arg0),c,hbytes(arg0,arg1))

def date( n, rest='' ):
	# n:int in format 032003 <-> 03 20:03
	# rest - 'MM.YYYY', not request
	d = n/10000
	h = (n%10000)/100
	if rest:
		if '.' not in rest: rest = ' '+rest
	m = n%100
	return '%02d%s %02d:%02d'%(d,rest,h,m)

def load_known_hosts():
	global KNOWN_HOSTS, KNOWN_HOSTS_PATH
	if len( KNOWN_HOSTS ): return
	def spl( l ):
		a = l.split()
		return (a[0],l[len(a[0]):].lstrip()[:-1])
	KNOWN_HOSTS=reduce(lambda d,p:d.setdefault(p[0],p[1]) and d,[spl(l) for l in open(KNOWN_HOSTS_PATH)],{})

def ip( sip ):
	return KNOWN_HOSTS.get( sip, '' )

def html_ip( sip ):
	hostdescr = ip( sip )
	if hostdescr:
		return '<span title="%s">%s</span>'%(sip,
		        hostdescr)
	else:
		return '<span title="Unknown host" style="color: coral;">%s</span>'%sip

def html_memo( txt ):
	return txt.replace( '\n', '<br>' )

def autofmt( titles, rec ):
	# titles:string like 'ip,bytes...' NO SPACE!
	i = 0
	r = []
	for t in titles:
		if t == 'ip':
			r.append( html_ip( rec[i] ) )
		elif t == 'bytes':
			r.append( html_hbytes( rec[i] ) )
		elif t == 'port':
			r.append( html_serv( rec[i] ) )
		elif t == 'proto':
			r.append( html_proto( rec[i] ) )
		elif t == 'date':
			r.append( date( rec[i] ) )
		elif t == 'memo':
			r.append( html_memo( rec[i] ) )
		else:
			r.append( rec[i] )
		i += 1
	return r

def query( sqlexpr, db ):
	try:
		con = sqlite.connect( db )
		cur = con.cursor()
		cur.execute( sqlexpr )
		res = cur.fetchall()
		return res
	except:
		return None

def query1( sqlexpr, db ):
	try:
		con = sqlite.connect( db )
		cur = con.cursor()
		cur.execute( sqlexpr )
		res = cur.fetchall()
		return (res,cur.description)
	except:
		return (None,cur.description)


def _titles( titles_names, extra='' ):
	s = '<tr>\n'
	for x in titles_names:
		s += '<td width="170" %s><b>'%extra + x + '</b></td>\n'
	s += '</tr>\n'
	return s

def html_titles( titles_names, line_ind=0, line_count=-1 ):
	if line_ind == 0:
		extra = 'style="background-color: lemonchiffon; color: darkgreen;"'
		return _titles( titles_names, extra )
	elif line_ind%26==0 and line_ind<>(line_count-1):
		extra = 'style="background-color: lemonchiffon; color: darkgray;"'
		return _titles( titles_names, extra )
	else:
		return ''


def show_in_html_table( sqlexpr, headers, db='/var/log/ipcad/ipcad.db' ):
	# headers:string 'IP address:ip,SUM of bytes:bytes,...' NO SPACE!
	res = query( sqlexpr, db )
	if not res: return ''

	harr = headers.split( ',' )
	titles_names = map( lambda p:p.split(':')[0], harr )
	titles_types = map( lambda p:p.split(':')[1], harr )

	load_known_hosts()
	s = '<table cellpadding="2" cellspacing="2">\n'
	i = 0
	cnt = len( res )
	for r in res:
		fmtr = autofmt( titles_types, r )
		tt = html_titles( titles_names, i, cnt )
		s += tt+'\n'
		if i%2:
			s += '<tr style="background-color: #F0F0F0;">'
		else:
			s += '<tr>'
		for x in fmtr:
			if type( x ) <> type( '' ): x = str(x)
			s += '<td>'+x+'</td>\n'
		s += '</tr>\n'
		i += 1
	s += '</table>'
	return s


def show_in_text( sqlexpr, db='/var/log/ipcad/ipcad.db' ):
	res,descr = query1( sqlexpr, db )
	if not res: return ''

	ds = reduce( lambda i,d:i+d[0]+'|', descr, '' )[:-1]
	s = ds+'\n\n'

	for reclist in res:
		rec = reduce( lambda i,r:i+str(r)+'|', reclist, '' )[:-1]
		s += rec + '\n'
	return s


def show_in_html_table1( sqlexpr, db='/var/log/ipcad/ipcad.db' ):
	deftit = {
		'src':'ip','dst':'ip','packets':'dummy','bytes':'bytes',
		'srcport':'port','dstport':'port','proto':'proto',
		'if':'dummy','ipfw_in_p':'dummy','ipfw_in_b':'bytes',
		'ipfw_out_p':'dummy','ipfw_out_b':'bytes','ipcad_stat':'memo',
		'date':'date'
	}

	# headers:string 'IP address:ip,SUM of bytes:bytes,...' NO SPACE!
	res,descr = query1( sqlexpr, db )
	if not res: return ''

	titles_names = [d[0] for d in descr]
	titles_types = [deftit.get(d[0],'dummy') for d in descr]

	load_known_hosts()
	s = '<table cellpadding="2" cellspacing="2">\n'
	i = 0
	cnt = len( res )
	for r in res:
		fmtr = autofmt( titles_types, r )
		tt = html_titles( titles_names, i, cnt )
		s += tt+'\n'
		if i%2:
			s += '<tr style="background-color: #F0F0F0;">'
		else:
			s += '<tr>'
		for x in fmtr:
			if type( x ) <> type( '' ): x = str(x)
			s += '<td>'+x+'</td>\n'
		s += '</tr>\n'
		i += 1
	s += '</table>'
	return s



if __name__ == '__main__':
	program = sys.argv[0]

	try:
  		opts, args = getopt.getopt( sys.argv[1:], 'hd:m' )
  		db = '/var/log/ipcad/ipcad.db'; human = 0
  		for o,a in opts:
			if o == '-d':
				db = a
			elif o == '-h':
				usage()
			elif o == '-m':
				human = 1
		if not args:
			panic( 'Where is SQL expression? Run with -h!' )

		sqlexpr = args[0]

		if not human:
			print show_in_text( sqlexpr, db )
		else:
			print HEADER%locals()
			print show_in_html_table1( sqlexpr, db )
			print FOOTER

	except getopt.GetoptError, x:
  		sys.stderr.write( 'Syntax error: %s!\n'%str(x) ) 
  		usage()
	except SystemExit, x:
  		sys.exit( int( str (x) ) )
	except Exception, x:
  		panic( 'Error occurs [%s]: %s'%(x.__class__.__name__,str(x)) )
