#!/bin/sh
case "$1" in
start)
	/usr/local/bin/ipcad -rds
	echo -n ' ipcad traffic metter'
	;;
stop)
	if [ -f /var/run/ipcad.pid ]; then
		kill -TERM `cat /var/run/ipcad.pid`
		rm -f /var/run/ipcad.pid
		echo -n ' ipcad'
	fi
	;;
restart)
	if [ -f /var/run/ipcad.pid ]; then
		kill -HUP `cat /var/run/ipcad.pid`
		echo 'ipcad restarted'
	fi
	;;
*)
	echo "Usage: ${0##*/}: { start | stop | restart }" 2>&1
	exit 65
	;;
esac
