#!/usr/local/bin/python

import getopt
import sys
import pysqlite2.dbapi2 as sqlite
import time
import commands

USAGE = '''-c dump|stat -d DB-file -- create dump table
-i IPCAD-file|\'&0\' -d DB-file [-s] -- flush IPCAD traf [and statistics]
-s -d DB-file -- flush only statistics
'''

def panic( msg ):
  sys.stderr.write( msg + '\n' )
  sys.exit( 1 )

def out( msg ):
  sys.stdout.write( msg + '\n' )

# date NOW
def date():
  d = time.localtime()
  s = '%02d%02d%02d'%(d[2],d[3],d[4])
  return int(s)

try:

  opts,args = getopt.getopt( sys.argv[1:], 'c:i:d:sh' )
  to_create = ''; db = ''; flushed = ''; stat = 0
  for o, a in opts:
    if o == '-c':
      to_create = a
    elif o == '-i':
      flushed = a
    elif o == '-d':
      db = a
    elif o == '-s':
      stat = 1
    elif o == '-h':
      panic( USAGE )

  if not db:
    panic( 'Unknown database. Run -h!' )

  con = sqlite.connect( db )
  cur = con.cursor()

  if to_create:
    # create table
    if to_create == 'dump':
      sqlexpr = '''create table dump(
      src text,dst text,packets int,bytes int,srcport int,dstport int,proto int,
      if text,date int)
      '''
    elif to_create == 'stat':
      sqlexpr = '''create table stat(
      ipfw_in_p int,ipfw_in_b int,ipfw_out_p int,ipfw_out_b int,ipcad_stat text,      date int)
      '''
    else:
      panic( 'Unknown table. Known tables are dump,stat' )
    cur.execute( sqlexpr )
    con.commit()
    out( 'Created known table '+to_create )
    sys.exit( 0 )

  if stat:
    # need statistics too:
    ipfw_out = commands.getstatusoutput( 'ipfw sh|egrep \'divert .* ip from 192\'' ) 
    ipfw_in = commands.getstatusoutput( 'ipfw sh|egrep \'divert .* ip from any to\'' ) 
    ipcad_stat = commands.getstatusoutput( 'rsh 127.0.0.1 stat' )
    if ipfw_in[0]<>0 or ipfw_out[0]<>0 or ipcad_stat[0]<>0:
      panic( 'Error to flush statistics. Used ipfw, egrep, rsh. See source code' )
    ipfw_in = ipfw_in[1]
    ipfw_out = ipfw_out[1]
    ipfw_in_arr = ipfw_in.split()
    ipfw_out_arr = ipfw_out.split()
    ipfw_in_rule = ipfw_in_arr[0]
    ipfw_out_rule = ipfw_out_arr[0]
    ipfw_in_p = ipfw_in_arr[1]
    ipfw_out_p = ipfw_out_arr[1]
    ipfw_in_b = ipfw_in_arr[2]
    ipfw_out_b = ipfw_out_arr[2]
    ipcad_stat = ipcad_stat[1]

    sqlexpr = 'insert into stat values('
    sqlexpr += '%s,%s,%s,%s,\'%s\',%d'%(
                ipfw_in_p,ipfw_in_b,ipfw_out_p,ipfw_out_b,ipcad_stat,date() )
    sqlexpr += ')'
    cur.execute( sqlexpr )
    out( sqlexpr )
    
    commands.getstatusoutput( 'ipfw -q zero '+ipfw_in_rule )
    commands.getstatusoutput( 'ipfw -q zero '+ipfw_out_rule )

    if not flushed:
      # only stat, without dump!
      con.commit()
      sys.exit( 0 )

  if not flushed:
    panic( 'Use -i to select flushed file' )    

  if flushed == '&0':
    f = sys.stdin
  else:
    f = open( flushed )
  for line in f:
    flds = line.split()
    if len( flds ) <> 8: continue
    sqlexpr = 'insert into dump values('
    sqlexpr += '\'%s\',\'%s\',%d,%d,%d,%d,%d,\'%s\',%d'%(
               flds[0],flds[1],
               int(flds[2]),int(flds[3]),int(flds[4]),int(flds[5]),
	       int(flds[6]),flds[7],
               date()
               )
    sqlexpr += ')'
    cur.execute( sqlexpr )
    out( sqlexpr )
  con.commit()
except getopt.GetoptError, x:
  sys.stderr.write( 'Syntax error: %s!\n'%str(x) )
  panic( USAGE )
except SystemExit, x:
  sys.exit( int( str(x) ) )
except Exception, x:
  panic( 'Error occurs [%s]: %s'%(x.__class__.__name__,str(x)) )
