#!/bin/sh

sendto="192.168.1.2"

#ftplog=/var/log/traf-ftp.log
ftppid=/var/run/traf-ftp.pid
ftpin=/tmp/ftp.in
ftpout=/tmp/ftp.out
ftpcmd="/usr/bin/ftp -V $sendto"
ftpusr=anonymous
ftppswd=
ftpdir=/
rep=/var/log/ipcad/traf.`date +'%m.%Y'`.html
repdir=`dirname $rep`
repzfile=`basename $rep`.zip


#                        Flush statistics (ipcad, ipfw counters) ::

/usr/local/bin/trafstfl.py -s -d /var/log/ipcad/ipcad.db >/dev/null
logger 'Flush trafic statistics'

#               Generate report for trafic dump ::

logger 'Start IPCAD report generating...'
/usr/bin/m4 /usr/local/etc/trafst/trafst.m4 > "$rep"
/usr/local/bin/zip -9j "$rep.zip" $rep 1>/dev/null
# create date-stammed copy of dump, it'll be compress by /usr/local/etc/periodic/monthly/100.rotate-ipcad
mv /var/log/ipcad/ipcad.db /var/log/ipcad/ipcad.`cat /var/log/ipcad/ipcad.date`.db
/usr/local/bin/trafstfl.py -c dump -d /var/log/ipcad/ipcad.db >/dev/null
/usr/local/bin/trafstfl.py -c stat -d /var/log/ipcad/ipcad.db >/dev/null
logger 'IPCAD report was generate'

#                  Send report to FTP server ::

logger 'Start IPCAD report sending...'
/usr/local/bin/empty -p $ftppid -i $ftpin -o $ftpout -f $ftpcmd #-L $ftplog
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'Name' "$ftpusr\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'Password:' "$ftppswd\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'ftp>' "cd pub\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'ftp>' "bin\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'ftp>' "lcd $repdir\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'ftp>' "put $repzfile\n"
/usr/local/bin/empty -w -i $ftpout -o $ftpin 'ftp>' "bye\n"
logger 'IPCAD report was send'

#                      Remove garbage after FTPing ::

/usr/local/bin/empty -k `cat $ftppid` 2>/dev/null
#rm $ftpin $ftpout $rep "$rep.zip" 2>/dev/null
rm $ftpin $ftpout $rep 2>/dev/null
