#!/usr/bin/python
import os, sys, os.path, shutil
from sus_consts import *
from sus_utils import *
from string import *

def LoadProviders():
    providers.clear()
    for line in open(providers_file, "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            providers[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')

def LoadItems(sProviderID):
    itemsindex.clear()
    for line in open(itemsindex_file%(sProviderID,), "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            itemsindex[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')
    items.clear()
    for line in open(items_file%(sProviderID,), "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            items[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')

def get_switches(str):
    l = string.find(str, "<switches>")+10
    r = string.rfind(str, "</switches>")
    return str[l:r]

LoadProviders()
fs = []

print "Available providers\n============"
i = 0
for sProviderID in providers.keys():
    print ' ', i, ' ', sProviderID
    i = i + 1
print "Select Providers (ex: 0,2,3): "
sp = string.split(raw_input(), ',')

for iProviderID in sp:
    pr_keys = providers.keys()
    sProviderID = pr_keys[int(iProviderID)]
    print "Select provider '%s' locales (ex: en,ru): "%sProviderID
    lc = string.split(raw_input(), ',')
    print "Enter provider '%s' OS SP number (ex: 4): "%sProviderID
    spn = raw_input()
    
    LoadItems(sProviderID)
    for itemkey in itemsindex.keys():
        varr = split(itemkey, '.')
        locale = varr[conIdLocale]
        spnum = varr[conIdSpMajorVer]
        if (locale in lc) and (spnum == "" or spnum==spn):
            guid = itemsindex[itemkey][conFieldItemsIndexGUID]
            file = AdjustInstallationCodeBase2(items[guid][conFieldItemInstallation], localCabPool)
            order = items[guid][conFieldItemOrder]
            fs.append((int(order), file, get_switches(items[guid][conFieldItemInstallation])))

def mycmp(a, b):
#    print repr(a), repr(b),
    return cmp(a[0], b[0])

fs.sort(mycmp)

pp = ""
while pp == "" or (not os.path.exists(pp)):
    print "Enter path, where should place files: "
    pp = raw_input()

bat = open(os.path.join(pp, "install.cmd"), "w")
for f in fs:
    print "Copying file %s"%f[1]
    shutil.copyfile(f[1], os.path.join(pp, os.path.basename(f[1])))
    bat.write(os.path.basename(f[1]) + ' ' + f[2] + '\r\n')

