#    SUSfL (SUS for Linux) is a clean room implementation of SUS running under Linux.
#    Copyright (C) 2004  Vladimir Umnov
#
#    This file is part of SUSfL.
#
#    SUSfL is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    SUSfL is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from socket import *
from sus_consts import *
import string, os.path

def ConvertLocale(sInputLocale):
    lsInputLocale = string.lower(sInputLocale)
    if lsInputLocale == "zh-tw":
        newsInputLocale = "zhtw"
    elif lsInputLocale == "zh-hk":
        newsInputLocale = "zhtw"
    elif lsInputLocale == "zh-cn":
        newsInputLocale = "zhcn"
    elif lsInputLocale == "zh-sg":
        newsInputLocale = "zhcn"
    elif lsInputLocale == "zh-mo":
        newsInputLocale = "zhtw"
    elif lsInputLocale == "pt-br":
        newsInputLocale = "ptbr"
    elif lsInputLocale == "pt-pt" or lsInputLocale == "ptpt":
        newsInputLocale = "pt"
    elif lsInputLocale == "nb-no" or lsInputLocale == "nn-no" or lsInputLocale == "nbno" or lsInputLocale == "nnno":
        newsInputLocale = "no"
    elif lsInputLocale == "iw-il":
        newsInputLocale = "he"
    else:
        iHyphenPos = string.find(lsInputLocale, '-')
        if iHyphenPos > 0:
            sLanguage = string.lower(sInputLocale[:iHyphenPos])
            newsInputLocale = sLanguage
        else:
            newsInputLocale = sInputLocale
    return newsInputLocale

#added on 08/23/2002 for 682869
def GetSuite(oSuiteNodes):
#    con_iMaxSuiteNodes = 25
    sFirstSuiteFound = ""
    if len(oSuiteNodes) > 0:
#        iSuiteNodeLen = oSuiteNodes.length()
#        if iSuiteNodeLen > con_iMaxSuiteNodes:
#            iSuiteNodeLen = con_iMaxSuiteNodes
#        for i in xrange(0, iSuiteNodeLen):
        for node in oSuiteNodes:
            for item in node.childNodes:
                sSuiteText = ""
                if item.nodeType == item.TEXT_NODE:
                    sSuiteText = item.data
                else:
                    for tn in item.childNodes:
                        if tn.nodeType == tn.TEXT_NODE:
                            sSuiteText = sSuiteText + tn.data
                sSuiteText = string.lower(string.strip(sSuiteText))
                if sSuiteText <> "ver_suite_terminal" and sSuiteText <> "ver_suite_singleuserts":
                    if sFirstSuiteFound == "":
                        sFirstSuiteFound = sSuiteText
                    if sSuiteText == "ver_suite_datacenter":
                        break
            if sSuiteText <> "ver_suite_datacenter":
                sSuiteText = sFirstSuiteFound
            sSuiteText = string.upper(sSuiteText)
            if sSuiteText == "":
                sSuiteText = "n"
            return sSuiteText
    else:
        return "n" #on 08/28/2002 in case no suite nodes returned from control. This case in never going to happen

def GetPlatformString(sysinfo):
    try:
        oOsLocaleNode = None
        oPlatformNode = None
        oVersionNode = None
        oProcArchNode = None
        oSuiteNodes = []
        oProductTypeNode = None
        
        for node in sysinfo.childNodes:
            if node.nodeName == 'platform':
                oPlatformNode = node
            if node.nodeName == 'locale' and node.hasAttribute("context") and node.getAttribute("context")=='OS':
                for ccnode in node.childNodes:
                    if ccnode.nodeName == 'language':
                        oOsLocaleNode = ccnode
                
        sPlatformName = oPlatformNode.getAttribute("name")
        for node in oPlatformNode.childNodes:
            if node.nodeName == 'version':
                oVersionNode = node
            if node.nodeName == 'processorArchitecture':
                oProcArchNode = node
            if node.nodeName == 'suite':
                oSuiteNodes.append(node)
            if node.nodeName == 'productType':
                oProductTypeNode = node
            
          
        sMajVersion = oVersionNode.getAttribute("major")
        sMinVersion = oVersionNode.getAttribute("minor")
        sBuild = oVersionNode.getAttribute("build")
        sSPMajor = oVersionNode.getAttribute("servicePackMajor")
        sSPMinor = oVersionNode.getAttribute("servicePackMinor")

        sProcArch = ""
        for tn in oProcArchNode.childNodes:
            if tn.nodeType == tn.TEXT_NODE:
                sProcArch = sProcArch + tn.data
        sProcArch = string.strip(sProcArch)

        sOsLocale = ""
        for tn in oOsLocaleNode.childNodes:
            if tn.nodeType == tn.TEXT_NODE:
                sOsLocale = sOsLocale + tn.data
        sOsLocale = ConvertLocale(string.strip(sOsLocale))
        
        #for 682869 on 08/23/2002
        sSuiteNode = GetSuite(oSuiteNodes)
        #for 682869 on 08/23/2002	
        #cahnged for 682817 on 08/28/2002
        if oProductTypeNode is not None:
            sProductTypeNode = ""
            for tn in oProductTypeNode.childNodes:
                if tn.nodeType == tn.TEXT_NODE:
                    sProductTypeNode = sProductTypeNode + tn.data
            sProductTypeNode = string.strip(sProductTypeNode)
        else:
            sProductTypeNode = ""
        #changed for 682817 on 08/28/2002
        #for 682817 on 08/28/2002
        if string.lower(sProductTypeNode) == "ver_nt_domain_controller":
            sProductTypeNode = "VER_NT_SERVER"
        #for 682817 on 08/28/2002
        return string.lower(sPlatformName + "." + sMajVersion + "." + sMinVersion + "." + sProcArch + "." + \
                     sOsLocale +  "." + sProductTypeNode + "." + sSuiteNode + "." + sBuild + "." + sSPMajor + "." + sSPMinor)
    except:
        return "error.errore.error.error.error.error.error.error.error.error"

#added on 08/23/2002 for 682869
def GetMoreGeneralPlatform(sPlatform, iSpecificityRank):
    sEmpty = ""
    sSpEmpty = "."
    sNoDes = "n"
    sKey = ""

    aParts = string.split(sPlatform, '.')
    sBasePlatform = aParts[conIdPlatformName - 2] + "." + aParts[conIdPlatformMajorVer - 2] + \
                    "." + aParts[conIdPlatformMinorVer - 2] + "." + aParts[conIdProcessor - 2] + "." + \
                    aParts[conIdLocale - 2]
    sProductType = aParts[conIdProductType - 2]
    sSuite = aParts[conIdSuite - 2]
    sBuild = aParts[conIdBuild - 2]
    sServicePack = aParts[conIdSpMajorVer - 2] + "." + aParts[conIdSpMinorVer - 2]

            #full prodType and Suite varying sp and build
    if iSpecificityRank == 1:
        sKey = sBasePlatform + "." + sProductType + "." + sSuite + "." + sBuild + "." + sSpEmpty
    elif iSpecificityRank == 2:
        sKey = sBasePlatform + "." + sProductType + "." + sSuite + "." + sEmpty + "." + sServicePack
    elif iSpecificityRank == 3:
        sKey = sBasePlatform + "." + sProductType + "." + sSuite + "." + sEmpty + "." + sSpEmpty
            #prodType present with Suite as blank varying sp and build
    elif iSpecificityRank == 4:
        sKey = sBasePlatform + "." + sProductType + "." + sEmpty + "." + sBuild + "." + sServicePack
    elif iSpecificityRank == 5:
        sKey = sBasePlatform + "." + sProductType + "." + sEmpty + "." + sBuild + "." + sSpEmpty
    elif iSpecificityRank == 6:
        sKey = sBasePlatform + "." + sProductType + "." + sEmpty + "." + sEmpty + "." + sServicePack
    elif iSpecificityRank == 7:
        sKey = sBasePlatform + "." + sProductType + "." + sEmpty + "." + sEmpty + "." + sSpEmpty
            #blank prodType with blank Suite varying sp and build
    elif iSpecificityRank == 8:
        sKey = sBasePlatform + "." + sEmpty + "." + sEmpty + "." + sBuild + "." + sServicePack
    elif iSpecificityRank == 9:
        sKey = sBasePlatform + "." + sEmpty + "." + sEmpty + "." + sBuild + "." + sSpEmpty
    elif iSpecificityRank == 10:
        sKey = sBasePlatform + "." + sEmpty + "." + sEmpty + "." + sEmpty + "." + sServicePack
    elif iSpecificityRank == 11:
        sKey = sBasePlatform + "." + sEmpty + "." + sEmpty + "." + sEmpty + "." + sSpEmpty
            #there are no cases where productType is empty and suite is "n" so those cases are skipped
    return sKey

def GetProductFromID(sCombinedID):
    aParts = string.split(sCombinedID, '.')
    if aParts is not None:
         return aParts[conIdProduct]

def GetItemNameFromID(sCombinedID):
    aParts = string.split(sCombinedID, '.')
    if aParts is not None:
         return aParts[conIdItemName]

def EncodeValue(sInputStr):
    return sInputStr #Server.HTMLEncode(sInputStr)


def GetProviderFromID(sCombinedID):
	return string.split(sCombinedID, ".")[conIdProvider]

def GetItemGUID(sItemID):
#    global itemsindex
 
    if itemsindex.has_key(sItemID):
        return itemsindex[sItemID][0]
    else:
        return False
#    aItemGuid = itemsindex[sItemID]
#    if len(aItemGuid)>0 and aItemGuid[0] <> "":
#        return aItemGuid[0]
#	Else
#		GetItemGUID = false

def GetItemStringGUID(sItemID, g_sLocale):
#    global items, itemstringsindex

    sProviderID = GetProviderFromID(sItemID)
    sItemGuid = GetItemGUID(sItemID)
    if sItemGuid <> False:
        sHash = items[sItemGuid][conFieldItemStringGUID]
        key = sProviderID + "." + g_sLocale + "." + sHash
        #print "key"
        if itemstringsindex.has_key(key):
            sGUID = itemstringsindex[key][conFieldItemStringsIndexHash]
        else:
            sGUID = itemstringsindex[sProviderID + ".en." + sHash][conFieldItemStringsIndexHash]
        return sProviderID + "." + sGUID
    else:
        return False


def GetItemTitle(sItemID, g_sLocale):
#    global itemstrings
    sItemStringGuid = GetItemStringGUID(sItemID, g_sLocale)
    return itemstrings[sItemStringGuid][conFieldItemStringsTitle]


def GetProviderTitle(sProviderID, g_sLocale):
#    global providerstrings
    key = sProviderID + "." + g_sLocale
    if providerstrings.has_key(key):
    	return providerstrings[key][conFieldProviderStringsTitle]
    else:
        return providerstrings[sProviderID + ".en"][conFieldProviderStringsTitle]

def GetPlatformNameFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdPlatformName]

def GetProcessorArchitectureFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdProcessor]
    
def GetPlatformMajorFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdPlatformMajorVer]

def GetPlatformMinorFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdPlatformMinorVer]

def GetBuildFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdBuild]

def GetLocaleFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdLocale]

def GetServicePackMajorFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdSpMajorVer]

def GetServicePackMinorFromID(sCombinedID):
    aParts = string.split(sCombinedID, ".")
    return aParts[conIdSpMinorVer]

def AdjustInstallationCodeBase(sInstallation, sLocalCodebaseUrlPrefix):
    iCodeBaseStart = string.find(string.lower(sInstallation), "href=") + 6
    iCodeBaseEnd = string.find(sInstallation, '"', iCodeBaseStart)
    sCodebaseURL = sInstallation[iCodeBaseStart:iCodeBaseEnd]
    iLastSlash = string.rfind(sCodebaseURL, "/")
    sFilename = sCodebaseURL[iLastSlash + 1:]
    sTargetURL = sLocalCodebaseUrlPrefix + "/" + sFilename
    sFinalInstallation = string.replace(sInstallation, sCodebaseURL, sTargetURL) #, 1, len(sInstallation), 1)
    return sFinalInstallation

def AdjustInstallationCodeBase2(sInstallation, sLocalCodebaseUrlPrefix):
    iCodeBaseStart = string.find(string.lower(sInstallation), "href=") + 6
    iCodeBaseEnd = string.find(sInstallation, '"', iCodeBaseStart)
    sCodebaseURL = sInstallation[iCodeBaseStart:iCodeBaseEnd]
    iLastSlash = string.rfind(sCodebaseURL, "/")
    sFilename = sCodebaseURL[iLastSlash + 1:]
    sTargetURL = os.path.join(sLocalCodebaseUrlPrefix, sFilename)
    sFinalInstallation = sTargetURL
    return sFinalInstallation

#def itemIsApproved(aFields, banneditems):
#	const conApproved = 1
#	const conMissing = 2
#	if g_bUseApprovedItemsList then
#		dim sPublisherPlusName, aFieldsApprovedItems
#		sPublisherPlusName = aFields(conFieldItemPublisherName) & "." & aFields(conFieldItemName)
#		aFieldsApprovedItems = approveditems.LookupFields(sPublisherPlusName)
#		If isarray(aFieldsApprovedItems)then
#			if aFieldsApprovedItems(conApproved) = 1 and aFieldsApprovedItems(conMissing) = 0 then
#				if ItemIsBanned(aFields, banneditems) then
#					itemIsApproved = false
#				else
#					itemIsApproved = true
#				end if
#			end if
#		Else
#			itemIsApproved = false
#		End If
#	else
#		if ItemIsBanned(aFields, banneditems) then
#			itemIsApproved = false
#		else
#			itemIsApproved = true
#		end if
#	end if
#End Function

def send_head(url):
    url = url[7:]
    i = url.find('/')
    host = url[:i]
    file = url[i:]
    if host.find(':') > 0:
        host,port = host.split(':')
    else:
        port = 80
    sock = socket(AF_INET, SOCK_STREAM)
    sock.connect((host, int(port)))
    sock.send("HEAD %s HTTP/1.0\r\n\r\n"%file)
    lines = sock.recv(1024)
    res = {}
    for line in lines.split('\r\n'):
        if line.find(':') > 0:
            par,value = line.split(': ')
            res[par] = value
    if res.has_key('Content-Length') and res.has_key('Last-Modified'):
        return res['Content-Length'], res['Last-Modified']
    else:
        return None 
