#    SUSfL (SUS for Linux) is a clean room implementation of SUS running under Linux.
#    Copyright (C) 2004  Vladimir Umnov <uvi@ezmail.ru>
#
#    This file is part of SUSfL.
#
#    SUSfL is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    SUSfL is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, sys, os.path, shutil, time
from stat import *
from sus_consts import *
from sus_utils import *
from string import *


FullSync = True
if UseWUServer:
    au_path = WUServer
    mssus_path = WUServer
else:
    au_path = conCabURL
    mssus_path = conMSSUSURL    

res = send_head("%saucatalog1.cab"%mssus_path)
if res is None:
    print 'Error in sending HEAD request to aucatalog1.cab'
    sys.exit()
if os.path.exists(prefix + 'aucatalog1.cab'):
    st = os.stat(prefix + 'aucatalog1.cab')
    if res[1] == time.strftime("%a, %d %b %Y %H:%M:%S GMT", time.gmtime(st[ST_MTIME])) \
       and res[0] == str(st[ST_SIZE]):
        print 'Sync not needed'
        FullSync = False
#        sys.exit()

if FullSync:
    if not os.path.exists(prefix + 'tmp'):
        os.mkdir(prefix + 'tmp')
    if not os.path.exists(prefix + 'content'):
        os.mkdir(prefix + 'content')
    os.chdir(prefix + 'tmp')

    os.system("wget -c %saucatalog1.cab"%mssus_path)
    os.system("cabextract -q -L aucatalog1.cab")
    for fname in os.listdir(prefix + 'tmp'):
        if not (fname == "aucatalog1.cab"):
            fn = string.join(string.split(fname, '!'), '/')
            if not os.path.exists(prefix + os.path.dirname(fn)):
                os.makedirs(prefix + os.path.dirname(fn))
    #	print fname, prefix + os.path.join(os.path.dirname(fn), os.path.basename(fn))
            shutil.move(fname, prefix + os.path.join(os.path.dirname(fn), os.path.basename(fn)))
    shutil.move("aucatalog1.cab", prefix+"aucatalog1.cab")

    os.system("wget -c %saurtf1.cab"%mssus_path)
    os.system("cabextract -q aurtf1.cab")
    for fname in os.listdir(prefix + 'tmp'):
        if not (fname == "aurtf1.cab"):
            fn = string.join(string.split(fname, '!'), '/')
            if not os.path.exists(prefix + 'content/' + os.path.dirname(fn)):
                os.makedirs(prefix + 'content/' + os.path.dirname(fn))
    #	print fname, prefix + 'content/' + os.path.join(os.path.dirname(fn), os.path.basename(fn))
            shutil.move(fname, prefix + 'content/' + os.path.join(os.path.dirname(fn), os.path.basename(fn)))
    shutil.move("aurtf1.cab", prefix+"aurtf1.cab")

    os.rmdir(prefix + 'tmp')

def LoadProviders():
    providers.clear()
    for line in open(providers_file, "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            providers[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')

def LoadItems(sProviderID):
    itemsindex.clear()
    for line in open(itemsindex_file%(sProviderID,), "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            itemsindex[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')
    items.clear()
    for line in open(items_file%(sProviderID,), "rt").readlines():
        pos = string.find(line, ',')
        if pos > 0:
            items[line[:pos]] = string.split(string.strip(line[pos+1:]), '@|')

os.chdir(prefix + 'content')
LoadProviders()
fs = {}
allfs = {}
for sProviderID in providers.keys():
    LoadItems(sProviderID)
    for itemkey in itemsindex.keys():
        locale = split(itemkey, '.')[6]
        guid = itemsindex[itemkey][conFieldItemsIndexGUID]
        file = AdjustInstallationCodeBase2(items[guid][conFieldItemInstallation], localCabPool)
        base_file = os.path.basename(file)
        if not allfs.has_key(base_file):
            allfs[base_file] = True
        if (sus_update_locales is None) or (sus_update_locales.has_key(sProviderID) and (locale in sus_update_locales[sProviderID])):
            if not fs.has_key(file):
                fs[file] = True
                if os.path.exists('old/' + os.path.basename(file)):
                    print 'moving old update to content instead of download it'
                    shutil.move('old/' + os.path.basename(file), file)
                if not os.path.exists(file):
                    if UseWUServer:
                        url = AdjustInstallationCodeBase2(items[guid][conFieldItemInstallation], WUServer + 'content')
                    else:
                        url = AdjustInstallationCodeBase2(items[guid][conFieldItemInstallation], conCabURL)
                    os.system("wget -c %s"%url)
for fname in os.listdir(prefix + 'content'):
    if not allfs.has_key(fname) and os.path.isfile(fname):
        if not os.path.exists(prefix + 'content/old'):
            os.mkdir(prefix + 'content/old')
        print 'moving update %s to old subdir'%os.path.basename(fname)
        shutil.move(fname, 'old/' + os.path.basename(fname))
