#    SUSfL (SUS for Linux) is a clean room implementation of SUS running under Linux.
#    Copyright (C) 2004  Vladimir Umnov <uvi@ezmail.ru>
#
#    This file is part of SUSfL.
#
#    SUSfL is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    SUSfL is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#susdebug = [True|False] if set to True will create files in /tmp: sus_*.log and
#put in this files windows requests
susdebug = False
#prefix is path with trailing slash to your virtual host folder
prefix = "/var/www/sus.int/"
#localCabPool is path with trailing slash to your pool, where updates will be stored
localCabPool = "/var/www/sus.int/content/"
#UseWUServer = [True|False] if set to True all updates will be downloaded from local 
#SUS server
UseWUServer = False
#WUServer is URL with trailing slash to local SUS server
WUServer = "http://192.168.1.2/"

#Select locales and providers to sync. If you want download updates for all providers 
#and locales simply not change this, else comment first line and uncomment second
#All available providers for now present in the example below
#Available locales: en,ru,.....
#sus_update_locales = None
sus_update_locales = { \
    "ie50x": ('en','ru'), \
    "ie55x": ('en','ru'), \
    "ie60x": ('en','ru'), \
    "netserver": ('en','ru'), \
    "win2k": ('en','ru'), \
    "winxp": ('en','ru')  \
}


#g_bUseApprovedItemsList and MaintainContentLocally not used at this time
g_bUseApprovedItemsList = True
MaintainContentLocally = True

#-----------------------------------
#Nothing should not be changed below
#-----------------------------------

conDetailsURL = "http://download.windowsupdate.com/msdownload/update/v3/static/RTF/"
conEULAURL = "http://download.windowsupdate.com/msdownload/update/v3/static/EULA/"
conCabURL = "http://download.windowsupdate.com/msdownload/update/v3-19990518/cabpool"
conMSSUSURL = "http://www.msus.windowsupdate.com/msus/v1/"
conSUURL = "http://v4.windowsupdate.microsoft.com/"

providers_file = prefix + "dictionaries/autoupdate/providers.txt"
providerstrings_file =  prefix + "dictionaries/autoupdate/providerstrings.txt"

products_file =  prefix + "dictionaries/autoupdate/%s/products.txt"
product2items_file =  prefix + "dictionaries/autoupdate/%s/product2items.txt"
productgroupstrings_file =  prefix + "dictionaries/autoupdate/%s/productgroupstrings.txt"
itemsindex_file =  prefix + "dictionaries/autoupdate/%s/itemsindex.txt"
items_file =  prefix + "dictionaries/autoupdate/%s/items.txt"
itemstringsindex_file =  prefix + "dictionaries/autoupdate/%s/itemstringsindex.txt"
itemstrings_file =  prefix + "dictionaries/autoupdate/%s/itemstrings.txt"


#global vars
providers = {}
providerstrings = {}
itemsindex = {}
itemstringsindex = {}
itemstrings = {}
items = {}
items_sent = {}

#all conFields* remapped to zero based arrays
    
con_iMaxProvidersAllowedInQueryXML = 25
con_iMaxProductsAllowedInQueryXML = 25
con_iMaxItemsAllowedInQueryXML = 200
con_iMaxRequestLength = 50000
con_iMaxDependencyDepth = 10

conIdProvider = 0
conIdProduct = 1
conIdPlatformName = 2
conIdPlatformMajorVer = 3
conIdPlatformMinorVer = 4
conIdProcessor = 5
conIdLocale = 6
conIdProductType = 7
conIdSuite = 8
conIdBuild = 9
conIdSpMajorVer = 10
conIdSpMinorVer = 11
conIdPublisherName = 12
conIdItemName = 13
conIdVersion = 14

conConsumerTable = 1
conConsumerDriversTable = 2
conCorporateTable = 3
conCorpDriversTable = 4
conAutoupdateTable = 5
conAutoupdateDriversTable = 6
conDynamicSetupTable = 7
conDynamicSetupDriversTable = 8


conTableProviders = 0
conTableProviderStrings = 1
conTableProducts = 2
conTableItems = 3
conTableProductGroupStrings = 4
conTableItemStrings = 5
conTableItemStringsIndex = 6
conTableProduct2Items = 7

conFieldProviderStringsTitle = 0
conFieldProviderStringsDescription = 1
conFieldProviderStringsEULA = 2
conFieldProviderStringsLogo = 3
conFieldProviderStringsURL = 4

conFieldProviderDetection = 0
conFieldProviderPreDetected = 1
conFieldProviderProducts = 2
conFieldProviderCustomDLL = 3

conFieldProductDetection = 0
conFieldProductCategory = 1
conFieldProductGroups = 2

#'TITLE,DESCRIPTION,EULA,ICON,URL
conFieldProductGroupStringsTitle = 0
conFieldProductGroupStringsDescription = 1
conFieldProductGroupStringsEULA = 2
conFieldProductGroupStringsIcon = 3
conFieldProductGroupStringsURL = 4

#'NAME,PROVIDERNAME,STRINGGUID,GROUP,DETECTION,INSTALLATION,INSTALLABLE,PRIORITY,SIZE,TIMESTAMP,EXCLUSIVE,HIDDEN,VERSION,ORDER
#   '1     2             3        4      5           6          7           8      9      10       11        12     13     14

conFieldItemName = 0
conFieldItemPublisherName = 1
conFieldItemStringGUID = 2
conFieldItemGroup = 3
conFieldItemDetection = 4
conFieldItemInstallation = 5
conFieldItemInstallable = 6
conFieldItemPriority = 7
conFieldItemSize = 8
conFieldItemTimeStamp = 9
conFieldItemExclusive = 10
conFieldItemHidden = 11
conFieldItemVersion = 12
conFieldItemOrder = 13

conFieldItemsIndexGUID = 0
conFieldItemsIndexDependencies = 1

conFieldItemStringsTitle = 0
conFieldItemStringsDescription = 1
conFieldItemStringsEULA = 2
conFieldItemStringsIcon = 3
conFieldItemStringsDetailsURL = 4

conFieldItemStringsIndexHash = 0

