
#define	COMMENT			'#'	/* comment char for config files */

#define AUTH_VECTOR_LEN		16
#define AUTH_PASS_LEN		16
#define AUTH_ID_LEN		64
#define AUTH_STRING_LEN		128	/* maximum of 253 */

#define FILTER_LEN		16
#define NAME_LENGTH		32

#define AUTH_HDR_LEN			20
#define MAX_SECRET_LENGTH		16
#define CHAP_VALUE_LENGTH		16

#define PW_AUTH_UDP_PORT		1645
#define PW_ACCT_UDP_PORT		1646

#define PW_TYPE_STRING			0
#define PW_TYPE_INTEGER			1
#define PW_TYPE_IPADDR			2
#define PW_TYPE_DATE			3

/* standard RADIUS codes */

#define	PW_ACCESS_REQUEST		1
#define	PW_ACCESS_ACCEPT		2
#define	PW_ACCESS_REJECT		3
#define	PW_ACCOUNTING_REQUEST		4
#define	PW_ACCOUNTING_RESPONSE		5
#define	PW_ACCOUNTING_STATUS		6
#define	PW_PASSWORD_REQUEST		7
#define	PW_PASSWORD_ACK			8
#define	PW_PASSWORD_REJECT		9
#define	PW_ACCOUNTING_MESSAGE		10
#define	PW_ACCESS_CHALLENGE		11
#define	PW_STATUS_SERVER		12
#define	PW_STATUS_CLIENT		13


/* standard RADIUS attribute-value pairs */

#define	PW_USER_NAME			1	/* string */
#define	PW_USER_PASSWORD		2	/* string */
#define	PW_CHAP_PASSWORD		3	/* string */
#define	PW_NAS_IP_ADDRESS		4	/* ipaddr */
#define	PW_NAS_PORT			5	/* integer */
#define	PW_SERVICE_TYPE			6	/* integer */
#define	PW_FRAMED_PROTOCOL		7	/* integer */
#define	PW_FRAMED_IP_ADDRESS		8	/* ipaddr */
#define	PW_FRAMED_IP_NETMASK		9	/* ipaddr */
#define	PW_FRAMED_ROUTING		10	/* integer */
#define	PW_FILTER_ID		        11	/* string */
#define	PW_FRAMED_MTU			12	/* integer */
#define	PW_FRAMED_COMPRESSION		13	/* integer */
#define	PW_LOGIN_IP_HOST		14	/* ipaddr */
#define	PW_LOGIN_SERVICE		15	/* integer */
#define	PW_LOGIN_PORT			16	/* integer */
#define	PW_OLD_PASSWORD			17	/* string */ /* deprecated */
#define	PW_REPLY_MESSAGE		18	/* string */
#define	PW_LOGIN_CALLBACK_NUMBER	19	/* string */
#define	PW_FRAMED_CALLBACK_ID		20	/* string */
#define	PW_EXPIRATION			21	/* date */ /* deprecated */
#define	PW_FRAMED_ROUTE			22	/* string */
#define	PW_FRAMED_IPX_NETWORK		23	/* integer */
#define	PW_STATE			24	/* string */
#define	PW_CLASS			25	/* string */
#define	PW_VENDOR_SPECIFIC		26	/* string */
#define	PW_SESSION_TIMEOUT		27	/* integer */
#define	PW_IDLE_TIMEOUT			28	/* integer */
#define	PW_TERMINATION_ACTION		29	/* integer */
#define	PW_CALLED_STATION_ID		30	/* string */
#define	PW_CALLING_STATION_ID		31	/* string */
#define	PW_NAS_IDENTIFIER		32	/* string */
#define	PW_PROXY_STATE			33	/* string */
#define	PW_LOGIN_LAT_SERVICE		34	/* string */
#define	PW_LOGIN_LAT_NODE		35	/* string */
#define	PW_LOGIN_LAT_GROUP		36	/* string */
#define	PW_FRAMED_APPLETALK_LINK	37	/* integer */
#define	PW_FRAMED_APPLETALK_NETWORK	38	/* integer */
#define	PW_FRAMED_APPLETALK_ZONE	39	/* string */
#define	PW_CHAP_CHALLENGE		60	/* string */
#define	PW_NAS_PORT_TYPE		61	/* integer */
#define	PW_PORT_LIMIT			62	/* integer */

/*	Accounting */

#define	PW_ACCT_STATUS_TYPE		40	/* integer */
#define	PW_ACCT_DELAY_TIME		41	/* integer */
#define	PW_ACCT_INPUT_OCTETS		42	/* integer */ /* not impl. */
#define	PW_ACCT_OUTPUT_OCTETS		43	/* integer */ /* not impl. */
#define	PW_ACCT_SESSION_ID		44	/* string */
#define	PW_ACCT_AUTHENTIC		45	/* integer */
#define	PW_ACCT_SESSION_TIME		46	/* integer */
#define	PW_ACCT_INPUT_PACKETS		47	/* integer */ /* not impl. */
#define	PW_ACCT_OUTPUT_PACKETS		48	/* integer */ /* not impl. */
#define	PW_ACCT_TERMINATE_CAUSE		49	/* integer */

/*	Merit Experimental Extensions */

#define	PW_AVAILABLE_TIME		209	/* integer */
#define	PW_INFO_PORT			210	/* integer */
#define	PW_PROXY_ACTION			211	/* string */
#define	PW_SIGNATURE			212	/* string */
#define	PW_TOKEN			213	/* string */
#define	PW_ACCT_RATE			214	/* string */
#define	PW_ACCT_CHARGE			215	/* string */
#define	PW_ACCT_TRANSACTION_ID		216	/* string */
#define	PW_ACCT_CHARGE_ALLOWED		217	/* string */
#define	PW_MAXIMUM_TIME			218	/* integer */
/* #define unavailable due to collision	219	*/ /* ??????? */
#define	PW_TIME_USED			220	/* integer */
#define	PW_HUNTGROUP_NAME		221	/* string */
#define	PW_USER_ID			222	/* string */
#define	PW_USER_REALM			223	/* string */

/*	Configuration Only Attributes (for check-items) */

#define	CI_COMMENT			1024	/* string */
#define	CI_XVALUE			1025	/* integer */
#define	CI_XSTRING			1026	/* string */
#define	CI_AUTHENTICATION_TYPE		1027	/* integer */
#define	CI_PROHIBIT			1028	/* integer */
#define	CI_USER_CATEGORY		1029	/* string */
#define	CI_GROUP_NAME			1030	/* string */
#define	CI_ENCRYPTED_PASSWORD		1031	/* string */
#define	CI_EXPIRATION			1032	/* date */
#define	CI_USER_PASSWORD		1033	/* string */
#define	CI_SIMULTANEOUS_USE		1034	/* integer */
#define	CI_SERVER_NAME			1035	/* string */

/*	Integer Translations */

/*	SERVICE TYPES	*/

#define	PW_LOGIN			1
#define	PW_FRAMED			2
#define	PW_CALLBACK_LOGIN		3
#define	PW_CALLBACK_FRAMED		4
#define	PW_OUTBOUND_USER		5
#define	PW_ADMINISTRATIVE_USER		6
#define	PW_SHELL_USER			7
#define PW_AUTHENTICATE_ONLY		8
#define PW_CALLBACK_ADMIN_USER		9

/*	FRAMED PROTOCOLS	*/

#define	PW_PPP				1
#define	PW_SLIP				2

/*	FRAMED ROUTING VALUES	*/

#define	PW_NONE				0
#define	PW_BROADCAST			1
#define	PW_LISTEN			2
#define	PW_BROADCAST_LISTEN		3

/*	FRAMED COMPRESSION TYPES	*/

#define	PW_VAN_JACOBSON_TCP_IP		1
#define	PW_IPX_HEADER_COMPRESSION	2

/*	LOGIN SERVICES	*/

#define	PW_TELNET			0
#define	PW_RLOGIN			1
#define	PW_TCP_CLEAR			2
#define	PW_PORTMASTER			3
#define	PW_LAT				4

/*	TERMINATION ACTIONS	*/

#define	PW_DEFAULT			0
#define	PW_RADIUS_REQUEST		1

/*	AUTHENTICATION TYPES */

#define AA_NONE		0	/* This is not a valid user id entry */
#define AA_UNIX		1	/* Use local Unix password file */
#define AA_AKRB		2	/* AFS Kerberos type authentication */
#define AA_MKRB		3	/* MIT Kerberos type authentication */
#define AA_RAD		4	/* Pass to remote RADIUS server */
#define AA_MNET		5	/* Do Merit specific authentication */
#define AA_KCHAP	6	/* Kerberos CHAP authentication */
#define AA_TACACS	7	/* Encrypted TACACS authentication */
#define AA_REALM	8	/* Find given realm in authfile */
#define AA_LOCAL	9
#define AA_FILE		10	/* ID/PW list in a file */

#define PW_AUTH_MAX	10	/* Highest authentication type */

/*	PROHIBIT PROTOCOL  */

#define PW_DUMB		0	/* 1 and 2 are defined in FRAMED PROTOCOLS */
#define PW_AUTH_ONLY	3
#define PW_ALL		255

/*	ACCOUNTING STATUS TYPES    */

#define PW_STATUS_START		1
#define PW_STATUS_STOP		2
#define PW_STATUS_ALIVE		3
#define PW_STATUS_MODEM_START	4
#define PW_STATUS_MODEM_STOP	5
#define PW_STATUS_CANCEL	6
#define PW_ACCOUNTING_ON	7
#define PW_ACCOUNTING_OFF	8

/*	ACCOUNTING TERMINATION CAUSES    */

#define PW_USER_REQUEST		1
#define PW_LOST_CARRIER		2
#define PW_LOST_SERVICE		3
#define PW_ACCT_IDLE_TIMEOUT	4
#define PW_ACCT_SESSION_TIMEOUT	5
#define PW_ADMIN_RESET		6
#define PW_ADMIN_REBOOT		7
#define PW_PORT_ERROR		8
#define PW_NAS_ERROR		9
#define PW_NAS_REQUEST		10
#define PW_NAS_REBOOT		11
#define PW_PORT_UNNEEDED	12
#define PW_PORT_PREEMPTED	13
#define PW_PORT_SUSPENDED	14
#define PW_SERVICE_UNAVAILABLE	15
#define PW_CALLBACK		16

/*	NAS PORT TYPES    */

#define PW_ASYNC		0
#define PW_SYNC			1
#define PW_ISDN_SYNC		2
#define PW_ISDN_SYNC_V120	3
#define PW_ISDN_SYNC_V110	4

/* Default Database File Names */

#ifndef RADIUS_DIR
#define RADIUS_DIR		"/usr/local/etc/raddb"
#endif

#ifndef RADACCT_DIR
#define RADACCT_DIR		"/usr/local/etc/radacct"
#endif

/*
 *	Note:	To change where these files go, do not change the #defines
 *		below, instead change the RADIUS_DIR #define above.
 */

#define RADIUS_DICTIONARY	"dictionary"
#define RADIUS_CLIENTS		"clients"
#define RADIUS_USERS		"users"
#define RADIUS_HOLD		"holdusers"
#define RADIUS_LOG		"logfile"
#define RADIUS_AUTH		"authfile"
#define RADIUS_PID		"radiusd.pid"
#define RADIUS_FSM		"radius.fsm"
#define RADIUS_DEBUG		"radius.debug"

#ifndef RADIUS_COMPRESS
#define RADIUS_COMPRESS		"/usr/ucb/compress"  /* might be gzip, etc. */
#endif

#ifndef RADIUS_LOCALSERVER
#define RADIUS_LOCALSERVER	"localserver"
#endif

#ifndef DEFAULT_REALM
#define DEFAULT_REALM		"DEFAULT"
#endif

#ifndef NULL_REALM
#define NULL_REALM		"NULL"
#endif


/******************************************************************
 *
 *      PW_PROTTYPE & PW_PROTTYPES - define authentication protocol allowed
 *                                   for particular realm entry in authfile.
 *
 *      The PW_PROTTYPE value is stored in the auth_ent.prot field.
 *      The PW_PROTTYPE value corresponds to the order of PW_PROTTYPES.
 *
 *****************************************************************/

#define PW_PROTTYPE_DFLT	0	/* Use this entry for any protocol */
#define PW_PROTTYPE_CHAP	1	/* Entry is for CHAP style authent. */
#define PW_PROTTYPE_PW		2	/* Entry is for id/pw style authent. */

#define PW_PROTTYPES_DFLT	"DEFAULT"
#define PW_PROTTYPES_CHAP	"CHAP"
#define PW_PROTTYPES_PW		"PW"

#ifndef	LOG_CONS
#define	LOG_DAEMON		0
#define	LOG_AUTH		0
#endif

#define	MGMT_POLL_SECRET	"Hardlyasecret"
#define	MAX_REQUESTS		128
#define	MAX_REQUEST_TIME	30	/* Lifetime of a request */
#define	CLEANUP_DELAY		5	/* Hold onto old requests this long */
#define	DEFAULT_INETD_TIMEOUT	15	/* Fifteen minutes by default */
#define	DEFAULT_TIMER_VALUE	3	/* Three seconds by default */
#define	ADDRESS_AGING		60*60	/* One hour by default */
#define	DFLT_TACACS_UDP_PORT	49	/* Default TACACS server port */
#define	SESS_ID_LEN		8	/* session id length */
#define SECONDS_PER_DAY		86400
#define TRUNCATION_DAY		7   /* Sunday is zero (0), daily is seven (7) */

#ifndef PROTO
#ifdef __STDC__
#define PROTO(x) x
#else
#define PROTO(x) ()
#undef const
#endif /* !__STDC__ */
#endif /* !PROTO */

/*	Define event structure (for events generated by AATV action functions */


#define	AA_DIRECT	0	/* Function gives direct reply */
#define	AA_SOCKET	1	/* Deferred reply returned on socket */
#define	AA_FORK		2	/* Spawn a process to wait for reply */
#define	AA_FREPLY	3	/* Fork & get reply on server socket */

