#! /bin/sh
# /etc/init.d/ppp: start or stop PPP.

FLAGS="start 20 2 3 4 5 . stop 20 0 1 6 ."
# NO_RESTART_ON_UPGRADE

test -x /usr/sbin/pppd -a -f /etc/ppp/ppp_on_boot || exit 0

case "$1" in
  start)
      echo -n "Starting up PPP link: pppd"
      start-stop-daemon --start --quiet --exec /usr/sbin/pppd -- call provider
      echo "."
    ;;
  stop)
      echo -n "Shutting down PPP link: pppd"
      start-stop-daemon --stop --quiet --exec /usr/sbin/pppd
      echo "."
    ;;
  restart|force-reload)
      $0 stop
      $0 start
    ;;
  *)
      echo "Usage: /etc/init.d/ppp {start|stop|restart|force-reload}"
      exit 1
    ;;
esac

exit 0
