/*
 *  linux/arch/i386/kernel/new_calls.c
 *  My new system calls
*/
#include <linux/slab.h>
#include <linux/gfp.h>
#include <asm/uaccess.h>
#include <asm/thread_info.h>

asmlinkage long sys_getstsize(void)
{
	return THREAD_SIZE;
}

asmlinkage long sys_upper(char *src, char *dst, int len)
{
	int i;
	char *buff;
	
	buff = (char *)kmalloc(len, GFP_KERNEL);
	memset(buff, 0, len);
	copy_from_user(buff, src, len);
	for (i = 0; i < len; i++)
		if((buff[i] >= 0x61) && (buff[i] <= 0x7A)) buff[i] -= 0x20;
	copy_to_user(dst, buff, len);
	kfree(buff);
	
	return len;
}
