/**	Модуль отображает информацию о процессе init (по умолчанию).
	Для информации о другом процессе, значение pid нужно передать в качестве параметра:
	insmod taskinfo.ko nr=<pid>
	В качестве такого процесса рекомендуется создать какой-нибудь процесс (например, top) 
	Информация сохраняется в /var/log/messages. Для просмотра используется команда:
	cat /var/log/messages | grep taskinfo: | tail -n 21	**/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/moduleparam.h>
#include <linux/sched.h>	///task_struct
#include <linux/types.h>	///pid_t
#include <linux/mm.h>		///vm_area_struct

static int nr = 1;

module_param(nr, int, 0000);
MODULE_PARM_DESC(nr, "Process ID");

static int __init taskinfo_init(void)
{
	struct task_struct *task;
	struct mm_struct *a_mm;	///адресное пространство
	struct vm_area_struct *vma;	///области памяти

	task = find_task_by_pid((pid_t)nr);

	if (!task) {
		printk(KERN_INFO "taskinfo: No find process with pid %d\n", nr);
		return 0;
	}

	a_mm = task->active_mm;
	vma = task->active_mm->mmap;

	///информация из дескриптора
	printk(KERN_INFO "taskinfo: Process %d information:\n", task->pid);
	printk(KERN_INFO "taskinfo: NAME - %s\n", task->comm);
	printk(KERN_INFO "taskinfo: STATE - %u\n", (u32)task->state);
	printk(KERN_INFO "taskinfo: UID - %d\n", task->uid);
	printk(KERN_INFO "taskinfo: GID - %d\n", task->gid);
	printk(KERN_INFO "taskinfo: EUID - %d\n", task->euid);
	printk(KERN_INFO "taskinfo: EGID - %d\n", task->egid);
	printk(KERN_INFO "taskinfo: FSUID - %d\n", task->fsuid);
	printk(KERN_INFO "taskinfo: FSGID - %d\n", task->fsgid);
	///области памяти
	printk(KERN_INFO "taskinfo: START MEMORY AREA ADDRESS - 0x%08X\n", (u32)vma->vm_start);
	printk(KERN_INFO "taskinfo:   END MEMORY AREA ADDRESS - 0x%08X\n", (u32)vma->vm_end);
	printk(KERN_INFO "taskinfo: MEMORY AREA LENGTH - 0x%08X\n", (u32)(vma->vm_end - vma->vm_start));
	///адреса сегментов
	printk(KERN_INFO "taskinfo: START CODE SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->start_code);
	printk(KERN_INFO "taskinfo:   END CODE SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->end_code);
	printk(KERN_INFO "taskinfo: CODE SEGMENT LENGTH - 0x%08X\n", (u32)(a_mm->end_code - a_mm->start_code));
	printk(KERN_INFO "taskinfo: START DATA SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->start_data);
	printk(KERN_INFO "taskinfo:   END DATA SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->end_data);
	printk(KERN_INFO "taskinfo: DATA SEGMENT LENGTH - 0x%08X\n", (u32)(a_mm->end_data - a_mm->start_data));
	printk(KERN_INFO "taskinfo: START BRK SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->start_brk);
	printk(KERN_INFO "taskinfo:   END BRK SEGMENT ADDRESS - 0x%08X\n", (u32)a_mm->brk);
	printk(KERN_INFO "taskinfo: BRK SEGMENT LENGTH - 0x%08X\n", (u32)(a_mm->brk - a_mm->start_brk));

	return 0;
}

static void __exit taskinfo_exit(void)
{
	return;
}

module_init(taskinfo_init);
module_exit(taskinfo_exit);

MODULE_LICENSE("GPL");
