#!/usr/bin/perl -w
#
# Проект администрирования корпоративной почты
# с сохранением пользователей, электронных сертификатов, и адресной книги
# в каталогах LDAP и с дальнейшим расширением функциональности
#
# Версия - 0.01 (:
#
# mailto:sandysandy@rambler.ru
#
# 1. необходимы каталоги с доступом для записи процессу
#    tmp - в него будут временно сохраняться для выдачи сертификаты
#    key - здесь хранятся приватные ключи пользователей (нет записи в каталоге LDAP ?)
#
# 2. конфигурационный файл start.conf:
#    base_dn = dc=domain, dc=ru
#    server = ldaps://ldap.domain.ru
#    login = cn=admin
#    password = secret
#    users_dn = ou=users
#    group_dn = ou=group
#    aliase_dn = ou=aliase
#    domain = domain.ru
#
#    l = Иркутск
#    o = Финансовая Академия
#
#    start_uid = 3001
#    users_group = mailuser
#    users_group_gid = 3000
#    home_directory = /dev/null
#    login_shell = /sbin/nologin
#
#    openssl = /usr/bin/openssl
#    sendmailMTACluster = servers
#

use CGI;
use locale;
use POSIX qw(setlocale);
use strict;
use Net::LDAP;

my $configfile = 'index.conf';
my $style1 = 'font-size: 8pt; font-weight:normal; font-family: arial;';
my $style2 = 'font-size: 10pt; font-weight:normal; font-family: arial;';
my $style3 = 'font-size: 12pt; font-weight:normal; font-family: arial;';

my $co = new CGI;
my %config;
my $ldap;

my $mode = 1;
$mode = $co->param('mode') if( $co->param('mode') );

# поднимаем локаль
setlocale( &POSIX::LC_ALL, "ru_RU.UTF-8" );
# Заголовок html
print $co->header(-type=>"text/html", -charset=>"utf-8"),
	$co->start_html(-title=>'Проект LDAP');
# очищаем tmp
unlink("tmp/*");
# чтение конфигурационного файла
exit_html("Ошибка чтения конфигурационного файла $configfile") unless open(FILE, "<$configfile");
while(<FILE>){
	my $str = $_;
	chomp $str;
	$str =~ s/^\s*//;
	$str =~ s/\s*$//;
        next if ( /^#/ or !length($str));
	next unless(/\s*(\w+)\s*=\s*(.+)/);
	my $a = $1;
	my $b = $2;
	$b =~ s/\s*$//;
	$config{$a}=$b; }
close (FILE);
exit_html("В кофигурационном файле отсутствует параметр base_dn.") unless($config{'base_dn'});
exit_html("В кофигурационном файле отсутствует параметр server.") unless($config{'server'});
exit_html("В кофигурационном файле отсутствует параметр login.") unless($config{'login'});
exit_html("В кофигурационном файле отсутствует параметр password.") unless($config{'password'});
exit_html("В кофигурационном файле отсутствует параметр users_dn.") unless($config{'users_dn'});
exit_html("В кофигурационном файле отсутствует параметр domain.") unless($config{'domain'});
my $ssl = '/usr/bin/openssl';
   $ssl=$config{'openssl'} if($config{'openssl'});
   
# подключаемся к серверу
my $dn = "$config{'login'}, $config{'base_dn'}";
$ldap = Net::LDAP->new($config{'server'}) or exit_html("Ошибка cоединения с сервером $config{'server'}");
$ldap->bind( $dn, password=>$config{'password'}) or exit_html('Ошибка! Проверте LDAP логин и пароль.');

# меню
print	$co->start_table({-border=>0, -bgcolor=>'#C1C1C1', -width=>'100%'}),
	$co->Tr({-align=>'center'}),
	# пользователи
	$co->td({-width=>'10%'},
		$co->table({-border=>0},
		$co->Tr,
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=1"},
			$co->img({-border=>0, -height=>'32', -width=>'32', -src=>'img/users.png'}))),
		$co->Tr, 
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=1"}, $co->span({-style=>$style1}, 'Пользователи'))))),
	# группы
	$co->td({-width=>'10%'},
		$co->table({-border=>0},
		$co->Tr,
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=2"},
			$co->img({-border=>0, -height=>'32', -width=>'32', -src=>'img/group.png'}))),
		$co->Tr, 
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=2"}, $co->span({-style=>$style1}, 'Группы'))))),
	# почтовые альясы
	$co->td({-width=>'10%'},
		$co->table({-border=>0},
		$co->Tr,
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=3"},
			$co->img({-border=>0, -height=>'32', -width=>'32', -src=>'img/aliase.png'}))),
		$co->Tr, 
		$co->td({-align=>'center'},
			$co->a({-href=>"index.cgi?mode=3"}, $co->span({-style=>$style1}, 'Альясы'))))),
	$co->td(),
	$co->td({-width=>'10%'},
		$co->table({-border=>0},
		$co->Tr,
		$co->td({-align=>'center'}, 'КОРПОРАЦИЯ'),
		$co->Tr, 
		$co->td({-align=>'center'}, "$config{'domain'}"))),
	$co->end_table, $co->hr;
# действия
if($co->param('delete_user')){
# удаляем пользователя
	my $uid = $co->param('uid');
	# удаляем ключ
	unlink("$config{'prefix_key'}/$uid.key");
	# поиск по группам
	my $dn = "$config{'group_dn'}, $config{'base_dn'}";
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(memberUid=$uid)(objectClass=posixGroup))");
	for( my $i = 0; $i < $mesg->count; $i++ ){
    		my $entry = $mesg->entry($i);
		my $cn = $entry->get_value('cn');
		# удаляем запись в группе
		$dn = "cn=$cn, $config{'group_dn'}, $config{'base_dn'}";
		$ldap->modify($dn, delete=>{'memberUid'=>"$uid"});
	}
	my $cn = $co->param('cn');
	# удаляем пользователя
	$dn = "cn=$cn, $config{'users_dn'}, $config{'base_dn'}";
	$ldap->delete($dn);
}elsif($co->param('save_user')){
# сохраняем параметры пользователя
	my $cn = $co->param('cn');
	my $dn = "$config{'users_dn'},$config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(cn=$cn)(objectClass=person))");
	my $entry = $mesg->entry;
	# получаем измененные значения
	my $title = $co->param('title');
	my $sn = $co->param('sn');
	my $telephoneNumber = $co->param('telephoneNumber');
	my $roomNumber = $co->param('roomNumber');
	#
	my $uid = $co->param('uid');
	my $uidNumber = $co->param('uidNumber');
	my $gidNumber = $co->param('gidNumber');
	my $homeDirectory = $co->param('homeDirectory');
	my $loginShell = $co->param('loginShell');
	my $description = $co->param('description');
	# заменяем различающиеся
	$dn = "cn=$cn,$config{'users_dn'},$config{'base_dn'}";
	$ldap->modify($dn, replace=>{'sn'=>"$sn"})
		if($entry->get_value('sn') ne $sn);
	$ldap->modify($dn, replace=>{'title'=>"$title"})
		if($entry->get_value('title') ne $title);
	$ldap->modify($dn, replace=>{'telephoneNumber'=>"$telephoneNumber"})
		if($entry->get_value('telephoneNumber') ne $telephoneNumber);
	$ldap->modify($dn, replace=>{'roomNumber'=>"$roomNumber"})
		if($entry->get_value('roomNumber') ne $roomNumber);
	#
	$ldap->modify($dn, replace=>{'uidNumber'=>"$uidNumber"})
		if($entry->get_value('uidNumber') ne $uidNumber);
	$ldap->modify($dn, replace=>{'gidNumber'=>"$gidNumber"})
		if($entry->get_value('gidNumber') ne $gidNumber);
	$ldap->modify($dn, replace=>{'homeDirectory'=>"$homeDirectory"})
		if($entry->get_value('homeDirectory') ne $homeDirectory);
	$ldap->modify($dn, replace=>{'loginShell'=>"$loginShell"})
		if($entry->get_value('loginShell') ne $loginShell);
	$ldap->modify($dn, replace=>{'description'=>"$description"})
		if($entry->get_value('description') ne $description);
	# при замене uid меняем и email
	if($entry->get_value('uid') ne $uid){
		$ldap->modify($dn, replace=>{'uid'=>"$uid"});
		$ldap->modify($dn, replace=>{'mail'=>"$uid\@$config{'domain'}"}) }
	# смена пароля
	if($co->param('password')){
		my $password = $co->param('password');
		my $salt = ('a'..'z','A'..'Z','0'..'9')[rand 62] . ('a'..'z','A'..'Z','0'..'9')[rand 62];
		$password = "{CRYPT}" . crypt($password, $salt);
		$ldap->modify($dn, replace=>{'userPassword'=>"$password"});
	} 
}elsif($co->param('new_user')){
# создаем нового пользователя
	# рисуем форму
	print	$co->start_form,
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, 'Введите необходимые данные для пользователя'),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Фамилия и инициалы'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->textfield(-name=>'cn', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'E-Mail'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->textfield(-name=>'mail', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Пароль'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->textfield(-name=>'password', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Должность')),
		$co->td($co->textfield(-name=>'title', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Номер телефона')),
		$co->td($co->textfield(-name=>'telephoneNumber', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Номер офиса')),
		$co->td($co->textfield(-name=>'roomNumber', -size=>'50')),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td(''),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_new_user', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}elsif($co->param('save_new_user')){
# сохраняем параметры нового пользователя
	# проверка необходимых параметров в конфиге
	exit_html('Отсутствует необходимый параметр ca_cert в конфигурационном файле') unless($config{'ca_cert'});
	exit_html('Отсутствует необходимый параметр ca_key в конфигурационном файле') unless($config{'ca_key'});
	exit_html('Отсутствует необходимый параметр password_ca в конфигурационном файле') unless($config{'password_ca'});
	exit_html("Файл сертификата CA $config{'ca_cert'} отсутствует") unless( -e "$config{'ca_cert'}");
	exit_html("Файл сертификата CA $config{'ca_key'} отсутствует") unless( -e "$config{'ca_key'}");
	my $cn = $co->param('cn');
	my $mail = lc($co->param('mail'));
	my $password = $co->param('password');
	exit_html('Ошибка! Отсутствуют необходимые параметры.') unless( $cn and $mail and $password);
	my $salt = ('a'..'z','A'..'Z','0'..'9')[rand 62] . ('a'..'z','A'..'Z','0'..'9')[rand 62];
	$password = "{CRYPT}" . crypt($password, $salt);
	my $uid = $mail;
	$mail .= "\@$config{'domain'}";
	# создание сертификатов
	# генерируем файл конфига для openssl
	open(CONFIG, '>tmp/config') or exit_html('Ошибка! Невожможно создать файл tmp/config.');
	print CONFIG <<EOF;
[ req ]
default_bits = 2048
distinguished_name = req_distinguished_name
prompt = no
[ req_distinguished_name ]
CN=RU
ST=Russia
O=$config{'l'}
OU=$config{'o'}
CN=$cn
emailAddress=$mail
EOF
	close CONFIG;
	# Генерация ключа key
	system("$ssl genrsa -out key/$uid.key 1024");
	# Генерация запроса csr
	system("$ssl req -new -key key/$uid.key -utf8 -config tmp/config -out tmp/$uid.csr");
	# Подписывание сертификата
	system("$ssl x509 -req -in tmp/$uid.csr -out tmp/$uid.cert -CA $config{'ca_cert'} -CAkey $config{'ca_key'} -CAcreateserial -days 1095 -passin pass:$config{'password_ca'}");
	# Генерация PKCS#12
	system("$ssl pkcs12 -export -in tmp/$uid.cert -inkey key/$uid.key -out tmp/$uid.p12 -password pass:");
	# Генерация DER
	system("$ssl x509 -inform PEM -in tmp/$uid.cert -outform DER -out tmp/$uid.der");
	#проверка на наличие всех сертификатов
	exit_html("Ошибка создания сертификата файла key/$uid.key") unless( -e "key/$uid.key");
	exit_html("Ошибка создания сертификата файла tmp/$uid.csr") unless( -e "tmp/$uid.csr");
	exit_html("Ошибка создания сертификата файла tmp/$uid.cert") unless( -e "tmp/$uid.cert");
	exit_html("Ошибка создания сертификата файла tmp/$uid.p12") unless( -e "tmp/$uid.p12");
	exit_html("Ошибка создания сертификата файла tmp/$uid.der") unless( -e "tmp/$uid.der");
	my $userCertificate;
	my $userPKCS12;
	{
		local $/ = undef;
        	open(FILE, "<tmp/$uid.der");
        	binmode FILE;
        	$userCertificate = <FILE>;
        	close FILE ;
		open(FILE, "<tmp/$uid.p12");
        	binmode FILE;
        	$userPKCS12 = <FILE>;
        	close FILE;
	}
	# Вычисляем текущий uidNumber
	my $uidNumber = 3000;
	my $gidNumber = 3000;
	$uidNumber = $config{'start_uid'} if($config{'start_uid'});
	$gidNumber = $config{'user_group_gid'} if($config{'user_group_gid'});
	my $dn ="$config{'users_dn'}, $config{'base_dn'}";
	my $mesg = $ldap->search( base=>$dn, filter=>'(objectClass=posixAccount)', attrs=>['uidNumber'] );
	for( my $i = 0; $i < $mesg->count; $i++ ){
    		my $entry = $mesg->entry($i);
		$uidNumber = $entry->get_value('uidNumber') if( $entry->get_value('uidNumber') > $uidNumber);
	}
	$uidNumber++;
	#Добавляем запись в базу
	$dn = "cn=$cn,$config{'users_dn'}, $config{'base_dn'}";
	$ldap->add($dn,
                attr=>[
	                    'cn'=>"$cn",
			    'sn'=>"$cn",
			    'uid'=>"$uid",
			    'gidNumber'=>"$gidNumber",
			    'uidNumber'=>"$uidNumber",
			    'description'=>'LDAP user',
			    'l'=>"$config{'l'}",
			    'o'=>"$config{'o'}",
			    'preferredLanguage'=>'russian',
			    'homeDirectory'=>"$config{'home_directory'}",
			    'loginShell'=>"$config{'login_shell'}",
			    'userPassword'=>"$password",
                            'userCertificate;binary'=>[ $userCertificate ],
			    'userPKCS12'=>"$userPKCS12",
			    'mail'=>"$mail",
			    'objectclass'=>[ 'top', 'person', 'organizationalPerson', 'inetOrgPerson', 'posixAccount', 'shadowAccount' ]
	                   ] ) or exit_html("Ошибка! Невозможно создать запись $dn");
	if($co->param('title')){
		my $title = $co->param('title');
		$ldap->modify($dn, add=>{'title'=>"$title"}); }
	if($co->param('telephoneNumber')){
		my $telephoneNumber = $co->param('telephoneNumber');
		$ldap->modify($dn, add=>{'telephoneNumber'=>"$telephoneNumber"}); }
	if($co->param('roomNumber')){
		my $roomNumber = $co->param('roomNumber');
		$ldap->modify($dn, add=>{'roomNumber'=>"$roomNumber"}); }
	# Добавляем пользователя в группу
	$dn = "cn=$config{'users_group'}, $config{'group_dn'}, $config{'base_dn'}";
	$ldap->modify($dn, add=>{'memberUid' =>"$uid"}) or exit_html("Ошибка! Невозможно добавить аттрибут memberUid в записи $dn");
}elsif($co->param('delete_group')){
# удаляем группу
	my $cn = $co->param('cn');
	$dn = "cn=$cn, $config{'group_dn'}, $config{'base_dn'}";
	$ldap->delete($dn);
	$mode = 2;
}elsif($co->param('save_group')){
# сохраняем параметры группы
	my $cn = $co->param('cn');
	my $dn = "$config{'group_dn'},$config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(cn=$cn)(objectClass=posixGroup))");
	my $entry = $mesg->entry;
	# получаем измененные значения
	my $gidNumber = $co->param('gidNumber');
	my $description = $co->param('description');
	# заменяем различающиеся
	$dn = "cn=$cn, $config{'group_dn'}, $config{'base_dn'}";
	$ldap->modify($dn, replace=>{'gidNumber'=>"$gidNumber"})
		if($entry->get_value('gidNumber') ne $gidNumber);
	$ldap->modify($dn, replace=>{'description'=>"$description"})
		if($entry->get_value('description') ne $description);
	# Цикл по пользователям
	$dn = "$config{'users_dn'}, $config{'base_dn'}";
	$mesg = $ldap->search( base=>$dn, filter=>'(objectClass=posixAccount)', attrs=>['uid']);
	for( my $i = 0; $i < $mesg->count; $i++ ){
		$entry = $mesg->entry($i);
		my $uid = $entry->get_value('uid');
		# Добавляем пользователей в группу
		$dn = "cn=$cn, $config{'group_dn'}, $config{'base_dn'}";
		if($co->param("check_$uid")){ $ldap->modify($dn, add=>{'memberUid' =>"$uid"});
		# Удаляем пользователей из группы
		}else{	$ldap->modify($dn, delete=>{'memberUid' =>"$uid"}); } }	
	$mode = 2;
}elsif($co->param('save_new_group')){
# сохраняем параметры новой группы
	my $cn = $co->param('cn');
	exit_html('Ошибка! Отсутствуют необходимые параметры.')unless($co->param('cn'));
	#Добавляем запись в базу
	my $gidNumber = 3000;
	$gidNumber = $config{'user_group_gid'} if($config{'user_group_gid'});
	my $dn ="$config{'group_dn'}, $config{'base_dn'}";
	my $mesg = $ldap->search(base=>$dn, filter=>'(objectClass=posixGroup)', attrs=>['gidNumber']);
	for( my $i = 0; $i < $mesg->count; $i++ ){
    		my $entry = $mesg->entry($i);
		$gidNumber = $entry->get_value('gidNumber') if( $entry->get_value('gidNumber') > $gidNumber); }
	$gidNumber++;
	$dn = "cn=$cn,$config{'group_dn'}, $config{'base_dn'}";
	$ldap->add($dn,
                attr=>[
	                    'cn'=>"$cn",
			    'gidNumber'=>"$gidNumber",
			    'objectclass'=>[ 'top', 'posixGroup' ]
	                   ] ) or exit_html("Ошибка! Невозможно создать запись $dn");
	if($co->param('description')){
		my $description = $co->param('description');
		$ldap->modify($dn, add=>{'description'=>"$description"}); }
	$mode = 2;
}elsif($co->param('new_group')){
# создаем новую группу
	# рисуем форму
	print	$co->start_form,
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, 'Введите необходимые данные для группы'),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Название'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->textfield(-name=>'cn', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Описание')),
		$co->td($co->textfield(-name=>'description', -size=>'50')),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td(''),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_new_group', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}elsif($co->param('delete_aliase')){
# удаляем aliase
	my $aliase = $co->param('sendmailMTAKey');
	$dn = "sendmailMTAKey=$aliase, $config{'aliases_dn'}, $config{'base_dn'}";
	$ldap->delete($dn);
	$mode = 3;
}elsif($co->param('save_aliase')){
# сохраняем параметры aliase
	my $aliase = $co->param('sendmailMTAKey');
	my $dn = "$config{'aliases_dn'},$config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(sendmailMTAKey=$aliase)(objectClass=sendmailMTAAliasObject))");
	my $entry = $mesg->entry;
	# получаем измененные значения
	my $sendmailMTAAliasValue = $co->param('sendmailMTAAliasValue');
	$sendmailMTAAliasValue =~ s/.+\s([\w\.]*)@[\w\.]+$/$1/;
	my $description = $co->param('description');
	# заменяем различающиеся
	$dn = "sendmailMTAKey=$aliase, $config{'aliases_dn'}, $config{'base_dn'}";
	$ldap->modify($dn, replace=>{'sendmailMTAAliasValue'=>"$sendmailMTAAliasValue"})
		if($entry->get_value('sendmailMTAAliasValue') ne $sendmailMTAAliasValue);
	$ldap->modify($dn, replace=>{'description'=>"$description"})
		if($entry->get_value('description') ne $description);
	$mode = 3;
}elsif($co->param('save_new_aliase')){
# сохраняем новый aliase
	# получаем необходимые параметры
	my $sendmailMTAKey = $co->param('sendmailMTAKey');
	my $sendmailMTACluster = 'servers';
	$sendmailMTACluster = $config{'sendmailMTACluster'} if($config{'sendmailMTACluster'});
	my $sendmailMTAAliasValue = $co->param('sendmailMTAAliasValue');
	$sendmailMTAAliasValue =~ s/.+\s([\w\.]*)@[\w\.]+$/$1/;
	exit_html('Ошибка! Отсутствуют необходимые параметры.')unless($sendmailMTAKey and $sendmailMTAAliasValue);
	my $dn = "sendmailMTAKey=$sendmailMTAKey, $config{'aliases_dn'}, $config{'base_dn'}";
	$ldap->add($dn,
                attr=>[
			'sendmailMTAKey'=>"$sendmailMTAKey",
			'sendmailMTACluster'=>"$sendmailMTACluster",
			'sendmailMTAAliasGrouping'=>'aliases',
			'sendmailMTAAliasValue'=>"$sendmailMTAAliasValue",
			    'objectclass'=>[ 'top', 'sendmailMTA', 'sendmailMTAAlias', 'sendmailMTAAliasObject' ]
	                   ] ) or exit_html("Ошибка! Невозможно создать запись $dn");
	if($co->param('description')){
		my $description = $co->param('description');
		$ldap->modify($dn, add=>{'description'=>"$description"}); }
	$mode = 3;
}elsif($co->param('new_aliase')){
# создаем новый aliase
	# получим список пользователей
	my $dn = "$config{'users_dn'}, $config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search(base=>$dn, filter=>"(objectClass=posixAccount)", attrs=>['cn', 'mail']);
	my @arr;
	for( my $i = 0; $i < $mesg->count; $i++ ){
		my $entry = $mesg->entry($i);
		my $cn = $entry->get_value('cn');
		my $mail = $entry->get_value('mail');
		push(@arr, "$cn $mail"); }
	# рисуем форму
	print	$co->start_form,
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, 'Введите необходимые данные'),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Значение'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->textfield(-name=>'sendmailMTAKey', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Пользователь'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->popup_menu(-name=>'sendmailMTAAliasValue', -values=>[@arr])),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Описание')),
		$co->td($co->textfield(-name=>'description', -size=>'50')),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td(''),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_new_aliase', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}elsif($co->param('user')){
# основные параметры пользователя
	my $uid = $co->param('user');
	my $dn = "$config{'users_dn'},$config{'base_dn'}";
	# поиск в каталоге по префиксу uid
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(uid=$uid)(objectClass=posixAccount))");
	# сохраняем доступные значения
	my $entry = $mesg->entry;
	my $title = $entry->get_value('title');
	my $sn = $entry->get_value('sn');
	my $telephoneNumber = $entry->get_value('telephoneNumber');
	my $roomNumber = $entry->get_value('roomNumber');
	# доступные только администратору
	my $cn = $entry->get_value('cn');
	   $uid = $entry->get_value('uid');
	my $uidNumber = $entry->get_value('uidNumber');
	my $gidNumber = $entry->get_value('gidNumber');
	my $homeDirectory = $entry->get_value('homeDirectory');
	my $loginShell = $entry->get_value('loginShell');
	my $description = $entry->get_value('description');
	# сохраняем сертификаты
	my $userCertificate = $entry->get_value('userCertificate;binary');
	my $userPKCS12 = $entry->get_value('userPKCS12');
	{
		local $/ = undef;
        	open(FILE, ">tmp/$uid.der");
        	binmode FILE;
        	print FILE $userCertificate;
        	close FILE ;
		open(FILE, ">tmp/$uid.p12");
        	binmode FILE;
        	print FILE $userPKCS12;
        	close FILE;
	}
	# Генерация PEM
	system("$ssl x509 -inform DER -in tmp/$uid.der -outform PEM -out tmp/$uid.cert");
	# рисуем форму
	print	$co->start_form,
		$co->hidden(-name=>'cn', -default=>$cn),
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, $co->u("Пользователь $sn")),
		$co->Tr(),
		$co->td('Пользовательский сертификат'), $co->td({-align=>'right'}, $co->a({-href=>"tmp/$uid.cert"},'здесь')),
		$co->Tr(),
		$co->td('Секретный ключ'), $co->td({-align=>'right'}, $co->a({-href=>"key/$uid.key"},'здесь')),
		$co->Tr(),
		$co->td('Сертификат PKCS#12'), $co->td({-align=>'right'}, $co->a({-href=>"tmp/$uid.p12"},'здесь')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'SN запись')),
		$co->td($co->textfield(-name=>'sn', -size=>'50', -default=>$sn)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Должность')),
		$co->td($co->textfield(-name=>'title', -size=>'50', -default=>$title)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Номер телефона')),
		$co->td($co->textfield(-name=>'telephoneNumber', -size=>'50', -default=>$telephoneNumber)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Номер офиса')),
		$co->td($co->textfield(-name=>'roomNumber', -size=>'50', -default=>$roomNumber)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: red;'}, 'Новый пароль')),
		$co->td($co->textfield(-name=>'password', -size=>'50')),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'UID запись')),
		$co->td($co->textfield(-name=>'uid', -size=>'50', -default=>$uid)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Числовой идентификатор')),
		$co->td($co->textfield(-name=>'uidNumber', -size=>'50', -default=>$uidNumber)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Групповой идентификатор')),
		$co->td($co->textfield(-name=>'gidNumber', -size=>'50', -default=>$gidNumber)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Домашний каталог')),
		$co->td($co->textfield(-name=>'homeDirectory', -size=>'50', -default=>$homeDirectory)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Командная оболочка')),
		$co->td($co->textfield(-name=>'loginShell', -size=>'50', -default=>$loginShell)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Description запись')),
		$co->td($co->textfield(-name=>'description', -size=>'50', -default=>$description)),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td({-align=>'left'}, $co->submit(-name=>'delete_user', -value=>'Удалить пользователя')),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_user', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}elsif($co->param('group')){
# основные параметры группы
	my $cn = $co->param('group');
	my $dn = "$config{'group_dn'}, $config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(cn=$cn)(objectClass=posixGroup))");
	my $entry = $mesg->entry;
	# сохраняем доступные значения
	my $gidNumber = $entry->get_value('gidNumber');
	my $description = $entry->get_value('description');
	   $cn = $entry->get_value('cn');
	# рисуем форму
	print	$co->start_form,
		$co->hidden(-name=>'cn', -default=>$cn),
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, "Группа $cn"),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'GID идентификатор')),
		$co->td($co->textfield(-name=>'gidNumber', -size=>'50', -default=>$gidNumber)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Описание')),
		$co->td($co->textfield(-name=>'description', -size=>'50', -default=>$description)),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr);
	my $member;
	$member=join(' ', @{$entry->get_value('memberUid', asref=>1)}) if($entry->exists('memberUid'));
	$dn = "$config{'users_dn'}, $config{'base_dn'}";
	$mesg = $ldap->search( base=>$dn, filter=>'(objectClass=posixAccount)', attrs=>['cn', 'uid']);
	for( my $i = 0; $i < $mesg->count; $i++ ){
		$entry = $mesg->entry($i);
		$cn = $entry->get_value('cn');
		my $uid = $entry->get_value('uid');
		if($member =~ m/\s*$uid\s*/){
			print	$co->Tr,
				$co->td({-align=>'left'},
				$co->checkbox_group(-name=>"check_$uid", -values=>'-', -defaults=>'-'),
				$co->a({-href=>"index.cgi?user=$uid&mode=1"}, "$uid")) 
		}else{
			print	$co->Tr,
				$co->td({-align=>'left'}, 
				$co->checkbox_group(-name=>"check_$uid", -values=>'-'),
				$co->a({-href=>"index.cgi?user=$uid&mode=1"}, "$uid")) }
		print	$co->td({-align=>'right'}, $cn); }
	print	$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td({-align=>'left'}, $co->submit(-name=>'delete_group', -value=>'Удалить группу')),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_group', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}elsif($co->param('aliase')){
	my $aliase = $co->param('aliase');
	my $dn = "$config{'aliases_dn'}, $config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	my $mesg = $ldap->search( base=>$dn, filter=>"(&(sendmailMTAKey=$aliase)(objectClass=sendmailMTAAliasObject))");
	my $entry = $mesg->entry;
	# сохраняем доступные значения
	my $sendmailMTAKey = $entry->get_value('sendmailMTAKey');
	my $sendmailMTAAliasValue = $entry->get_value('sendmailMTAAliasValue');
	my $description = $entry->get_value('description');
	# получим список пользователей
	$dn = "$config{'users_dn'}, $config{'base_dn'}";
	# поиск в каталоге по префиксу cn
	$mesg = $ldap->search(base=>$dn, filter=>"(objectClass=posixAccount)", attrs=>['cn', 'mail']);
	my @arr;
	for( my $i = 0; $i < $mesg->count; $i++ ){
		$entry = $mesg->entry($i);
		my $cn = $entry->get_value('cn');
		my $mail = $entry->get_value('mail');
		push(@arr, "$cn $mail"); }
	# рисуем форму
	print	$co->start_form,
		$co->start_table({-border=>'0', -align=>"center", -cellspacing=>'0', -cellpadding=>'4'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}),
		$co->th({-colspan=>'2'}, "sendmail aliase $sendmailMTAKey"),
		$co->Tr,
		$co->hidden(-name=>'sendmailMTAKey', -default=>$sendmailMTAKey),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Пользователь'),
			$co->span({-style=>'Color: red;'},'*')),
		$co->td($co->popup_menu(-name=>'sendmailMTAAliasValue', -values=>[@arr], -default=>$sendmailMTAAliasValue)),
		$co->Tr,
		$co->td($co->span({-style=>'Color: blue;'}, 'Описание')),
		$co->td($co->textfield(-name=>'description', -size=>'50', -default=>$description)),
		$co->Tr,
		$co->td({-colspan=>'2'}, $co->hr),
		$co->Tr,
		$co->td({-align=>'left'}, $co->submit(-name=>'delete_aliase', -value=>'Удалить aliase')),
		$co->td({-align=>'right'}, $co->submit(-name=>'save_aliase', -value=>'Сохранить параметры')),
		$co->end_table,
		$co->end_form;
	exit_html();
}

# Список пользователей
if($mode == 1){
	# поиск пользователей и формирование таблицы
	my $dn = "$config{'users_dn'},$config{'base_dn'}";
	my $mesg = $ldap->search( base=>$dn, filter=>'(objectClass=posixAccount)', attrs=>['cn', 'title', 'uid'] );
	print	$co->start_table({-border=>'0', -align=>'center', -cellspacing=>'0', -cellpadding=>'4', -width=>'80%'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}), 
			$co->th('Фамилия'),
			$co->th('Должность'),
			$co->th('E-Mail');
	for( my $i = 0; $i < $mesg->count; $i++ ){
		my $entry = $mesg->entry($i);
		my $uid = $entry->get_value('uid');
		print 	$co->Tr, 
			$co->td({-width=>'25%', -align=>'left'}, $co->a({-href=>"index.cgi?user=$uid&mode=1"}, $entry->get_value('cn'))), 
			$co->td({-align=>'center'}, $entry->get_value('title')), 
			$co->td({-width=>'15%', -align=>'right'}, "$uid\@$config{'domain'}"); }
	print	$co->end_table, 
		$co->hr,
		$co->start_form,
		$co->submit(-name=>'new_user', -value=>'Создать'),
		$co->end_form;
# Список групп
}elsif($mode == 2){
	# поиск групп и формирование таблицы
	my $dn = "$config{'group_dn'},$config{'base_dn'}";
	my $mesg = $ldap->search( base=>$dn, filter=>'(objectClass=posixGroup)', attrs=>['cn', 'gidNumber', 'description'] );
	print	$co->start_table({-border=>'0', -align=>'center', -cellspacing=>'0', -cellpadding=>'4', -width=>'80%'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}), 
			$co->th('Наименование'),
			$co->th('Описание'),
			$co->th('GID');
	for( my $i = 0; $i < $mesg->count; $i++ ){
		my $entry = $mesg->entry($i);
		my $cn = $entry->get_value('cn');
		print 	$co->Tr, 
			$co->td({-width=>'25%', -align=>'left'}, $co->a({-href=>"index.cgi?group=$cn&mode=2"}, $cn)), 
			$co->td({-align=>'center'}, $entry->get_value('description')), 
			$co->td({-width=>'15%', -align=>'right'}, $entry->get_value('gidNumber')); }
	print	$co->end_table, 
		$co->hr,
		$co->start_form,
		$co->submit(-name=>'new_group', -value=>'Создать'),
		$co->end_form;

# Список альясов
}else{
	# поиск альясов и формирование таблицы
	my $dn = "$config{'aliases_dn'},$config{'base_dn'}";
	my $mesg = $ldap->search(base=>$dn, filter=>'(objectClass=sendmailMTAAliasObject)', attrs=>['sendmailMTAKey', 'sendmailMTAAliasValue', 'description']);
	print	$co->start_table({-border=>'0', -align=>'center', -cellspacing=>'0', -cellpadding=>'4', -width=>'80%'}),
		$co->Tr({-bgcolor=>'#D4E1F7'}), 
			$co->th('Наименование'),
			$co->th('Значение'),
			$co->th('Описание');
	for( my $i = 0; $i < $mesg->count; $i++ ){
		my $entry = $mesg->entry($i);
		my $sendmailMTAKey = $entry->get_value('sendmailMTAKey');
		my $sendmailMTAAliasValue = $entry->get_value('sendmailMTAAliasValue');
		my $description = $entry->get_value('description');
		# для альяса находим соответствующий cn
		$dn = "$config{'users_dn'},$config{'base_dn'}";
		my $mesg2 = $ldap->search(base=>$dn, filter=>"(&(uid=$sendmailMTAAliasValue)(objectClass=posixAccount))");
		if(my $entry2 = $mesg2->entry){ $description = $entry2->get_value('cn'); }
		print 	$co->Tr,
			$co->td({-align=>'left'}, $co->a({-href=>"index.cgi?aliase=$sendmailMTAKey&mode=3"}, $sendmailMTAKey)),
			$co->td({-align=>'center'}, "$sendmailMTAAliasValue\@$config{'domain'}"),
			$co->td({-align=>'right'}, $description); }
	print	$co->end_table, 
		$co->hr,
		$co->start_form,
		$co->submit(-name=>'new_aliase', -value=>'Создать'),
		$co->end_form;
}
# отключаемся
$ldap->unbind;
print $co->end_html;

sub exit_html{
	my $error = shift;
	print $co->span({-style=>$style3}, $error), $co->end_html;
	exit; }
#конец фильма
